/* VARIABLES */
const max_per_page = 6;
const ext_data = [];
const params = new URLSearchParams(window.location.search);
var platform = (params.has('platform')) ? params.get('platform') : 'web';
var font_color = "";
var bg_color = "";
var page = 1;
var url_result;
var preview_volume = 0;
var stop_playback;

/* FUNCTIONS */
// take an array and paginate it
function paginate (arr, size) {
	return arr.reduce((acc, val, i) => {
		let idx = Math.floor(i / size)
		let page = acc[idx] || (acc[idx] = [])
		page.push(val)

		return acc
	}, [])
}

// get available bits products and output them to the viewer
function generate_list(get_page = page) {
	Twitch.ext.bits.getProducts().then(function(products) {
		// prepare the product list
		var products_paged = paginate(products, max_per_page);
		product_list = products_paged[get_page-1];

		var output = "";
		product_list.forEach(item => {
			output += '<div product-sku="'+item.sku+'" product-name="'+item.displayName+'" product-cost="'+item.cost.amount+'" class="item-box">';
			output += '<div class="item-box-price"><span class="price-number">'+item.cost.amount+'</span><span class="price-denom">bits</span></div>';
			output += '<div class="item-box-title">'+item.displayName+'</div>';
			output += '</div>';
		});

		// output the list
		$("#content").html(output);

		// pagination
		pages = products_paged.length;
		var buttons = "";
		if (pages > 1) {
			// back button
			var back_button = '<input type="button" name="back_button" direction="back" value="fast_rewind" style="margin-right: auto;" class="pagination-button" />';

			// next button
			var next_button = '<input type="button" name="next_button" direction="next" value="fast_forward" style="margin-left: auto;" class="pagination-button" />';

			// determine whether to show prev button
			if (get_page > 1) {
				buttons += back_button;
			}

			// determine whether to show next button
			if (get_page < pages) {
				buttons += next_button;
			}
		}

		// output pagination
		$("#pagination").html(buttons);

		// override the default border color for .item-box and .pagination-button
		$(".item-box, .pagination-button").css("border-color", "var("+font_color+")");
	});
}

function emote_chooser() {
	emotes = [
		"sentiment_frustrated",
		"sentiment_dissatisfied",
		"sentiment_very_dissatisfied",
		"sentiment_sad",
		"sentiment_stressed"
	];

	let options = emotes.length;
	let choice = Math.floor(Math.random() * options);

	return emotes[choice];
}

// generate the preview and checkout dialog
function generate_dialog(data) {
	// start by hiding and emptying the dialog in case it's been used before
	close_dialog();

	// then populate the loading spinner
	var dialog_loading = '<div style="width: 100%; height: 100%; text-align: center; vertical-align: middle;"><img src="./images/spinner.gif" alt="Loading..." title="Loading..." /></div>';
	$("#dialog-text").html(dialog_loading);

	// show the dialog
	$("#dialog-wrapper").slideDown(250);

	// create the dialog content
	var dialog_content = '<h3>'+data.name+'</h3>';

	if (data.msg === undefined) {
		// initiate the audio
		var audio = new Audio(data.url);
		audio.preload = "metadata";
		audio.load();

		// preview/checkout
		dialog_content += '<div class="text-box"><span class="text-box-header">Preview sound</span><br /><span class="text-box-disclaimer">(just for you)</span><br /><br />';
		dialog_content += '<div id="preview-controls"><div id="volume-slider"><div id="volume-slider-handle" class="ui-slider-handle">volume_up</div></div><div id="play-pause">play_arrow</div></div></div>';
		dialog_content += '<br /><div class="text-box"><span class="text-box-header">Play on stream</span><br />';
		if (data.stream !== 999) {
			// stream is online
			dialog_content += '<span class="text-box-disclaimer">(for everyone)</span><br />';
			dialog_content += '<div id="checkout-container">';
			dialog_content += '<div id="checkout-cost"><span class="price-icon"></span><span class="price-number">'+data.cost+'</span><span class="price-denom">bits</span></div>';
			dialog_content += '<div id="checkout-button">PLAY NOW</div>';
			if (data.cooldown > 0) {
				// there is a cooldown, show estimated waiting time
				dialog_content += '<div id="checkout-cooldown">(will play after a<br />'+data.cooldown+' second cooldown)</div>';
			}
		} else {
			// stream is offline
			dialog_content += '<span class="text-box-disclaimer">The stream is offline.</span><br /><span class="text-box-icon">'+emote_chooser()+'</span>';
		}
		dialog_content += '</div>';
	} else {
		// generic message
		dialog_content += '<div class="text-box">'+data.msg+'</div>';

		// close after 5 seconds
		var close_timer = setTimeout(function() {
			close_dialog();
		}, 5000);
	}

	// populate the dialog
	$("#dialog-text").html(dialog_content);

	// override the css styles
	$("#dialog-text .text-box").css("border-color", "var("+font_color+")");
	$("#dialog-text h3").css("color", "var("+font_color+")");

	var slider_handle = $("#volume-slider-handle");
	var volume_icon = "";
	$("#volume-slider").slider({
		min: 0,
		max: 10,
		value: preview_volume*10,
		create: function() {
			slider_handle.text(slider_icon($(this).slider("value")));
			audio.volume = preview_volume;
		},
		slide: function(event, ui) {
			slider_handle.text(slider_icon(ui.value));
			preview_volume = (ui.value/10).toFixed(1);
			audio.volume = preview_volume;
		}
	});

	function slider_icon(volume) {
		if (volume === 0) {
			return "volume_off";
		} else if (volume > 0 && volume < 6) {
			return "volume_down";
		} else {
			return "volume_up";
		}
	}

	function is_playing() {
		return audio
		&& audio.currentTime > 0
		&& !audio.paused
		&& !audio.ended
		&& audio.readyState > 2;
	}

	// handle playing the audio of the preview button
	$("#play-pause").on("click", function() {
		playback_status = is_playing();

		if (playback_status === false) {
			audio.play();
			var sound_duration = Math.round(audio.duration);
			$(this).text("stop");
			stop_playback = setTimeout(function() {
				$("#play-pause").text("play_arrow");
			}, sound_duration*1000);
		} else {
			audio.pause();
			audio.load();
			$(this).text("play_arrow");
			clearTimeout(stop_playback);
		}
	});

	// highlight the checkout button on hover
	$("#checkout-button, #checkout-cost").on("mouseover", function() {
		$("#checkout-button").css("background-color", "#4db5ff");
	}).on("mouseout", function() {
		$("#checkout-button").css("background-color", "#169fff");
	});

	// handle submitting the exchange to backend
	$("#checkout-button, #checkout-cost").on("click", function() {
		// start the transaction
		window.Twitch.ext.bits.useBits(data.sku);

		// kill the playback and reset
		if (is_playing() === true) {
			audio.pause();
			audio.load();
			$("#play-pause").text("play_arrow");
			clearTimeout(stop_playback);
		}
	});

	// closing the dialog
	function close_dialog() {
		// check that the dialog is open
		if ($("#dialog-wrapper").is(':visible')) {
			if (is_playing() === true) {
				audio.pause();
			}

			if (close_timer !== undefined) {
				clearTimeout(close_timer);
			}

			$("#dialog-wrapper").slideUp(250);
		}
	}

	$("#dialog-close").on("click", function() {
		// regular X button
		close_dialog();
	});
	$(document).on("keyup", function(e) {
		// press escape
		if (e.key === "Escape") { close_dialog(); }
	});
	$("#dialog-wrapper").on("click", function(e) {
		// click outside the dialog
		if ($(e.target).closest("#dialog").attr("id") !== "dialog" && $(e.target).closest("#dialog").attr("id") !== "volume-slider-handle") {
			close_dialog();
		}
	});
}

/* TWITCH EXTENSION HELPER SEGMENT */
// user authentication
window.Twitch.ext.onAuthorized(function(auth) {
	// prompt for userid if consent isn't given
	if (window.Twitch.ext.viewer.isLinked === false) {
		window.Twitch.ext.actions.requestIdShare();
	}

	// save useful vars
	ext_data["auth_token"] = auth.token;

	// generate the list of products
	generate_list();
});

// handle context changes to the extension
window.Twitch.ext.onContext(function(context) {
	// theme change - unlikely, but necessary
	if (context.theme !== undefined) {
		font_color = "--"+context.theme+"-font";
		bg_color = "--"+context.theme+"-bg";

		// make changes to background, borders and fonts
		$("body, #dialog").css("background-color", "var("+bg_color+")");
		$(".item-box, .pagination-button, #dialog, #dialog-close, #dialog-text .text-box, #dialog-text .submit").css("border-color", "var("+font_color+")");
		$("#dialog-text h3").css("color", "var("+font_color+")");
	}

	/* RESPONSIVENESS */
	if (platform === "mobile") {
		$("#content").css("height", "90%");
		$("#content").css("row-gap", "40px");
	}
});

// transaction outcomes
window.Twitch.ext.bits.onTransactionCancelled(function() {
	// transaction was cancelled

	// not sure we want a cancellation confirmation.. leave commented for now and do nothing
	/*$("#dialog-text h3").text("Cancelled");
	$("#dialog-text .text-box:nth-child(2)").remove();
	$("#dialog-text .text-box").text("Transaction cancelled.");*/
});

window.Twitch.ext.bits.onTransactionComplete(function(transaction) {
	// transaction completed
	data = {
		"request": "checkout",
		"sku": transaction.product.sku,
		"username": transaction.displayName,
		"transaction": transaction.transactionId,
		"cost": transaction.product.cost.amount
	}

	$.ajax({
		url: "https://www.kyppo.net/endpoints/twitch/soundalerts.php",
		type: "get",
		dataType: "json",
		crossDomain: true,
		headers: {
			"x-extension-jwt": ext_data["auth_token"]
		},
		data: data,
		success: function(res) {
			data = {
				"name": "Completed",
				"msg": "Exchange complete, thank you very much!"
			};
			generate_dialog(data);
		},
		error: function(xhr, status, error) {
			data = {
				"name": "Error",
				"msg": "Exchange failed."
			};
			generate_dialog(data);
		}
	});
});

/* JQUERY FUNCTIONS */
$(function() {
	// product box highlight on mouseover, click handling
	$(document).on({
	"mouseenter": function() {
		$(this).find(".item-box-title").css("font-size", "24px");
	},
	"mouseleave": function() {
		$(this).find(".item-box-title").css("font-size", "22px");
	},
	"click": function() {
		// handle clicking on the object
		var data = {
			"sku": $(this).attr("product-sku"),
			"name": $(this).attr("product-name"),
			"cost": $(this).attr("product-cost")
		}

		$.ajax({
			url: "https://www.kyppo.net/endpoints/twitch/soundalerts.php",
			type: "get",
			dataType: "json",
			crossDomain: true,
			headers: {
				"x-extension-jwt": ext_data["auth_token"]
			},
			data: {
				"request": "getsound",
				"sku": data.sku
			},
			success: function(res) {
				data["url"] = res.url;
				data["stream"] = res.status;
				data["cooldown"] = res.cooldown;
				generate_dialog(data);
			},
			error: function(xhr, status, error) {
				data = {
					"name": "Error",
					"msg": "An error occurred retrieving the sound data:<br />"+xhr.responseJSON.message
				};
				generate_dialog(data);
			}
		});
	}}, ".item-box");

	// pagination buttons
	$(document).on({
	"click": function() {
		var direction = $(this).attr("direction");
		if (direction === "back") {
			page = page-1;
			generate_list(page);
		}

		if (direction === "next") {
			page = page+1;
			generate_list(page);
		}
	}}, ".pagination-button");
});
